set autoscale 
set xtic auto 
set ytic auto 
set style line  1 lt 1 lw 1 lc rgb "#000000"
set style line  2 lt 1 lw 1 lc rgb "#FF0000"
set style line  3 lt 1 lw 1 lc rgb "#00FF00"
set style line  4 lt 1 lw 1 lc rgb "#0000FF"
 
set out 'RIXS_Map.ps'
set terminal postscript portrait enhanced color  "Times" 8 size 7.5,6
 
unset colorbox
 
energyshift=0
 
set multiplot 
set size 0.5,0.55
set origin 0,0
 
set ylabel "resonant energy (eV)" font "Times,10"
set xlabel "energy loss (eV)" font "Times,10"
 
set yrange [-7:1]
set xrange [-0.5:12.5]
 
plot "<(awk '((NR>5)&&(NR<1307)){for(i=3;i<=NF;i=i+2){printf \"%s \", $i}{printf \"%s\", RS}}' RIXS.dat)" matrix using ($2/100-0.5):($1*0.5+energyshift-10):(-$3) with image notitle 
 
set origin 0.5,0
 
set yrange [9:17]
set xrange [-0.5:12.5]
 
plot "<(awk '((NR>5)&&(NR<1307)){for(i=3;i<=NF;i=i+2){printf \"%s \", $i}{printf \"%s\", RS}}' RIXS.dat)" matrix using ($2/100-0.5):($1*0.5+energyshift-10):(-$3) with image notitle 
 
unset multiplot
 
set out 'RIXS_Spec.ps'
set terminal postscript portrait enhanced color  "Times" 8 size 7.5,5
 
set multiplot 
set size 0.25,1.0
set origin 0,0
 
set ylabel "E (eV)" font "Times,10"
set xlabel "XAS" font "Times,10"
set yrange [energyshift-10:energyshift+20]
set xrange [-2.0:0]
plot "XAS.dat"  using       3:($1+energyshift) notitle with lines ls  1
 
set size 0.8,1.0
set origin 0.2,0.0
 
set xlabel "Energy loss (eV)" font "Times,10"
unset ylabel 
unset ytics
set xrange [-0.5:12.5]
 
ofset = 0.5 
scale = 10.0
 
plot for [i=0:60] "RIXS.dat"  using 1:(-column(3+2*i)*scale+ofset*i-10 + energyshift) notitle with lines ls  4
 
unset multiplot
